{include file='_head.tpl'}
{include file='_header.tpl'}

<!-- page content -->
{if $view == ""}
	<style>
	.search-wrapper-prnt {
	display: none !important
	}
	</style>

    <div class="row x_content_row">
		<!-- content panel -->
		<div class="col-lg-12 w-100">
			<div class="d-flex align-items-center p-3 position-sticky x_top_posts">
				<div class="d-flex align-items-center gap-3 position-relative mw-0">
					<span class="headline-font fw-semibold side_widget_title p-0 flex-0">{__("Directory")}</span>
				</div>
			</div>
		
			<div class="p-3">
				<div class="row">
					<div class="col-sm-6 col-md-6 mb-3">
						<a href="{$system['system_url']}/directory/users" class="directory-card x_address d-block h-100 p-3 body-color">
							<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.5647 15.2197C14.1348 15.528 15.0292 16.0116 15.6409 16.5861C16.0219 16.9439 16.4159 17.4432 16.4883 18.0782C16.5665 18.7653 16.2485 19.3856 15.6772 19.9078C14.7182 20.7844 13.5522 21.5 12.0399 21.5H4.96015C3.44779 21.5 2.28177 20.7844 1.3228 19.9078C0.751481 19.3856 0.433458 18.7653 0.511739 18.0782C0.584083 17.4432 0.978131 16.9439 1.35906 16.5861C1.97085 16.0116 2.86511 15.528 3.43523 15.2197C3.56216 15.1511 3.67304 15.0911 3.76114 15.0408C6.66339 13.3828 10.3366 13.3828 13.2389 15.0408C13.3269 15.0911 13.4378 15.1511 13.5647 15.2197Z" fill="#58ca71"/><path d="M3.59668 7.37838C3.59668 4.68412 5.79187 2.5 8.49977 2.5C11.2077 2.5 13.4029 4.68412 13.4029 7.37838C13.4029 10.0726 11.2077 12.2568 8.49977 12.2568C5.79187 12.2568 3.59668 10.0726 3.59668 7.37838Z" fill="#58ca71"/><path d="M13.7776 10.9656C13.572 11.2407 13.4692 11.3783 13.5081 11.5144C13.5471 11.6506 13.6841 11.7128 13.9581 11.8373C14.5282 12.0963 15.1712 12.2419 15.8515 12.2419C18.1982 12.2419 20.1005 10.5088 20.1005 8.37097C20.1005 6.23309 18.1982 4.5 15.8515 4.5C15.5956 4.5 15.345 4.52061 15.1016 4.56011C14.8001 4.60902 14.6494 4.63347 14.5698 4.75422C14.4902 4.87497 14.5465 5.03357 14.6592 5.35075C14.8816 5.97695 15.0017 6.64504 15.0017 7.33871C15.0017 8.68342 14.5502 9.93204 13.7776 10.9656Z" fill="#58ca71"/><path d="M18.893 20.5C20.4249 20.5 21.6164 19.9038 22.6072 19.1596C23.1944 18.7186 23.5791 18.1506 23.4862 17.4806C23.4027 16.8788 22.9563 16.4309 22.5711 16.1336C21.94 15.6466 21.0193 15.2377 20.4392 14.98C20.3111 14.9231 20.1996 14.8735 20.1114 14.8322C18.981 14.3015 17.7373 13.9735 16.4669 13.8483C15.6476 13.7676 15.238 13.7272 15.1443 13.9501C15.0507 14.173 15.4155 14.4118 16.1451 14.8893C16.4221 15.0707 16.6902 15.265 16.9254 15.4673C17.4549 15.9226 18.2313 16.7422 18.3777 17.9186C18.4456 18.4638 18.367 18.9661 18.1903 19.4199C17.9799 19.9603 17.8747 20.2305 17.9657 20.3586C17.9715 20.3668 17.9751 20.3713 17.9816 20.3791C18.0837 20.5 18.3534 20.5 18.893 20.5Z" fill="#58ca71"/></svg>
							<h5 class="mt-3 fw-semibold h4">{__("Users")}</h5>
							<p class="m-0">{__("Help friends know you better and show them what you have in common")}</p>
						</a>
					</div>
					<div class="col-sm-6 col-md-6 mb-3">
						<a href="{$system['system_url']}/directory/posts" class="directory-card x_address d-block h-100 p-3 body-color">
							<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.42476 5.96656C6.58145 6.49615 6.27914 7.05249 5.74955 7.20917C4.16184 7.67891 3.67122 7.99964 3.43 8.4151C3.27585 8.68059 3.19912 9.0304 3.28691 9.72268C3.37843 10.4444 3.62427 11.3754 3.9895 12.7462L5.00185 16.5459C5.36709 17.9168 5.61705 18.8466 5.89654 19.5175C6.16472 20.1613 6.40448 20.424 6.66771 20.5751C6.93178 20.7267 7.28263 20.8022 7.97972 20.7109C8.70497 20.616 9.64091 20.366 11.0171 19.9951L11.4898 19.8678C12.0231 19.7241 12.5719 20.0399 12.7155 20.5731C12.8592 21.1064 12.5434 21.6552 12.0102 21.7989L11.4697 21.9445C10.1785 22.2925 9.11292 22.5796 8.23931 22.694C7.32231 22.814 6.46842 22.7668 5.67196 22.3096C4.87467 21.8519 4.40521 21.1385 4.05034 20.2866C3.71275 19.4763 3.42985 18.4143 3.08748 17.1292L2.03873 13.1929C1.69626 11.9076 1.41331 10.8457 1.3028 9.97429C1.18661 9.05805 1.23879 8.20589 1.7004 7.41087C2.38641 6.22933 3.65434 5.74336 5.18215 5.29135C5.71174 5.13467 6.26808 5.43697 6.42476 5.96656Z" fill="#dcce4f"/><path fill-rule="evenodd" clip-rule="evenodd" d="M20.4253 3.28231C19.6271 2.95101 18.5745 2.67059 17.2694 2.32287L16.2094 2.04043C14.9041 1.69265 13.8516 1.4122 12.9939 1.30229C12.1033 1.18818 11.3124 1.241 10.5821 1.66025C9.85117 2.07986 9.40864 2.73583 9.06207 3.5614C8.72864 4.35566 8.44647 5.40287 8.09691 6.70016L7.04517 10.6032L7.04517 10.6032C6.69559 11.9004 6.41338 12.9476 6.30275 13.8013C6.18777 14.6885 6.24094 15.4779 6.66391 16.2064C7.08651 16.9342 7.74618 17.3737 8.57474 17.7176C9.3729 18.0489 10.4255 18.3293 11.7306 18.677L12.7907 18.9595C14.0959 19.3073 15.1484 19.5877 16.0061 19.6976C16.8967 19.8117 17.6877 19.7589 18.4179 19.3396C19.1488 18.92 19.5914 18.2641 19.9379 17.4385C20.2714 16.6442 20.5535 15.597 20.9031 14.2997L21.9548 10.3967C22.3044 9.09953 22.5866 8.05231 22.6973 7.19861C22.8122 6.31139 22.7591 5.52199 22.3361 4.79352C21.9135 4.06567 21.2538 3.62623 20.4253 3.28231ZM13.0739 6.29109C12.6736 6.18445 12.2627 6.42247 12.1561 6.82272C12.0494 7.22297 12.2874 7.63389 12.6877 7.74053L17.4606 9.01221C17.8609 9.11885 18.2718 8.88084 18.3784 8.48059C18.4851 8.08034 18.247 7.66942 17.8468 7.56278L13.0739 6.29109ZM12.0508 10.0879C11.6505 9.98125 11.2396 10.2193 11.133 10.6195C11.0263 11.0198 11.2643 11.4307 11.6646 11.5373L14.051 12.1732C14.4513 12.2798 14.8622 12.0418 14.9688 11.6415C15.0755 11.2413 14.8375 10.8304 14.4372 10.7237L12.0508 10.0879Z" fill="#dcce4f"/></svg>
							<h5 class="mt-3 fw-semibold h4">{__("Posts")}</h5>
							<p class="m-0">{__("See what everyone’s up to and what’s on their minds")}</p>
						</a>
					</div>
					{if $system['pages_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/directory/pages" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.25 20.75C3.25 21.3023 3.69772 21.75 4.25 21.75C4.80229 21.75 5.25 21.3023 5.25 20.75L5.25 16.05C5.25 15.8843 5.38432 15.75 5.55 15.75L15.929 15.75C16.9976 15.75 17.8671 15.75 18.5254 15.6731C19.1789 15.5968 19.8334 15.4265 20.2644 14.9014C20.4597 14.6636 20.6043 14.3885 20.6876 14.092C20.8752 13.4248 20.613 12.7991 20.2815 12.2484C19.9486 11.6956 19.3919 10.9867 18.7531 10.1733C18.4666 9.80843 18.2854 9.57646 18.1648 9.3876C18.0517 9.21053 18.0316 9.1304 18.0258 9.08349C18.019 9.028 18.019 8.972 18.0258 8.91651C18.0316 8.8696 18.0517 8.78947 18.1648 8.6124C18.2854 8.42354 18.4665 8.19169 18.753 7.82686C19.3919 7.01337 19.9486 6.30448 20.2815 5.75161C20.613 5.20093 20.8752 4.57516 20.6876 3.90796C20.6043 3.61154 20.4597 3.33643 20.2644 3.09857C19.8334 2.57354 19.1789 2.40321 18.5254 2.32687C17.867 2.24997 16.9976 2.24998 15.9289 2.25H10.2297C8.79382 2.24998 7.64349 2.24997 6.74026 2.36594C5.80776 2.48567 5.02581 2.74063 4.40209 3.33629C3.77351 3.93659 3.49997 4.69704 3.37233 5.60363C3.2911 6.18067 3.2638 6.86128 3.25463 7.65317L3.25 20.75Z" fill="#3ddae5"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Pages")}</h5>
								<p class="m-0">{__("Never miss a thing out! Keep in touch with your fans and customers")}</p>
							</a>
						</div>
					{/if}
					{if $system['groups_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/directory/groups" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.21365 16.3972C9.29579 15.6726 10.5995 15.25 12 15.25C13.4005 15.25 14.7042 15.6726 15.7864 16.3972C16.8749 17.126 17.25 18.3957 17.25 19.5C17.25 19.9142 16.9142 20.25 16.5 20.25H7.5C7.08579 20.25 6.75 19.9142 6.75 19.5C6.75 18.3957 7.12515 17.126 8.21365 16.3972Z" fill="#b88bfd"/><path d="M8.75 11C8.75 9.20507 10.2051 7.75 12 7.75C13.7949 7.75 15.25 9.20507 15.25 11C15.25 12.7949 13.7949 14.25 12 14.25C10.2051 14.25 8.75 12.7949 8.75 11Z" fill="#b88bfd"/><path d="M14.75 6.5C14.75 4.98122 15.9812 3.75 17.5 3.75C19.0188 3.75 20.25 4.98122 20.25 6.5C20.25 8.01878 19.0188 9.25 17.5 9.25C15.9812 9.25 14.75 8.01878 14.75 6.5Z" fill="#b88bfd"/><path d="M3.75 6.5C3.75 4.98122 4.98122 3.75 6.5 3.75C8.01878 3.75 9.25 4.98122 9.25 6.5C9.25 8.01878 8.01878 9.25 6.5 9.25C4.98122 9.25 3.75 8.01878 3.75 6.5Z" fill="#b88bfd"/><path d="M7.54682 10.3485C7.51597 10.5612 7.5 10.7787 7.5 11C7.5 12.4176 8.15548 13.6821 9.17989 14.5069C8.6532 14.7034 8.15246 14.9533 7.68468 15.25H2.5C2.08579 15.25 1.75 14.9142 1.75 14.5C1.75 13.4263 2.07 12.1626 3.05401 11.4213C4.02988 10.6863 5.21666 10.25 6.5 10.25C6.85725 10.25 7.20701 10.2838 7.54682 10.3485Z" fill="#b88bfd"/><path d="M16.3153 15.25H21.5C21.9142 15.25 22.25 14.9142 22.25 14.5C22.25 13.4263 21.93 12.1626 20.946 11.4213C19.9701 10.6863 18.7834 10.25 17.5 10.25C17.1428 10.25 16.793 10.2838 16.4532 10.3485C16.4841 10.5612 16.5 10.7787 16.5 11C16.5 12.4176 15.8445 13.6821 14.8201 14.5069C15.3468 14.7034 15.8476 14.9533 16.3153 15.25Z" fill="#b88bfd"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Groups")}</h5>
								<p class="m-0">{__("Communicate and collaborate with the people who share your interests")}</p>
							</a>
						</div>
					{/if}
					{if $system['events_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/directory/events" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7 2C7 1.44772 6.55228 1 6 1C5.44772 1 5 1.44772 5 2V2.44885C5.38032 2.32821 5.78554 2.24208 6.21533 2.17961C6.46328 2.14357 6.72472 2.11476 7 2.09173V2Z" fill="#f97474"/><path d="M19 2.44885C18.6197 2.32821 18.2145 2.24208 17.7847 2.17961C17.5367 2.14357 17.2753 2.11476 17 2.09173V2C17 1.44772 17.4477 1 18 1C18.5523 1 19 1.44772 19 2V2.44885Z" fill="#f97474"/><path fill-rule="evenodd" clip-rule="evenodd" d="M13.0288 2H10.9712C9.02294 1.99997 7.45141 1.99994 6.21533 2.17961C4.92535 2.3671 3.8568 2.76781 3.01802 3.6746C2.18949 4.57031 1.83279 5.69272 1.66416 7.04866C1.49997 8.36894 1.49998 10.0541 1.5 12.1739V12.8261C1.49998 14.9459 1.49997 16.6311 1.66416 17.9513C1.83279 19.3073 2.18949 20.4297 3.01802 21.3254C3.8568 22.2322 4.92535 22.6329 6.21533 22.8204C7.45142 23.0001 9.02293 23 10.9712 23H13.0288C14.9771 23 16.5486 23.0001 17.7847 22.8204C19.0747 22.6329 20.1432 22.2322 20.982 21.3254C21.8105 20.4297 22.1672 19.3073 22.3358 17.9513C22.5 16.6311 22.5 14.9459 22.5 12.8261V12.1739C22.5 10.0541 22.5 8.36895 22.3358 7.04866C22.1672 5.69272 21.8105 4.57031 20.982 3.6746C20.1432 2.76781 19.0747 2.3671 17.7847 2.17961C16.5486 1.99994 14.9771 1.99997 13.0288 2ZM4.49783 9C4.03921 9 3.8099 9 3.66385 9.14417C3.51781 9.28833 3.51487 9.51472 3.509 9.96751C3.50027 10.6407 3.5 11.3942 3.5 12.2432V12.7568C3.5 14.9616 3.50182 16.5221 3.64887 17.7045C3.79327 18.8656 4.06263 19.5094 4.48622 19.9673C4.89956 20.4142 5.4647 20.6903 6.503 20.8412C7.57858 20.9975 9.00425 21 11.05 21H12.95C14.9957 21 16.4214 20.9975 17.497 20.8412C18.5353 20.6903 19.1004 20.4142 19.5138 19.9673C19.9374 19.5094 20.2067 18.8656 20.3511 17.7045C20.4982 16.5221 20.5 14.9616 20.5 12.7568V12.2432C20.5 11.3942 20.4997 10.6407 20.491 9.96751C20.4851 9.51472 20.4822 9.28833 20.3362 9.14417C20.1901 9 19.9608 9 19.5022 9H4.49783Z" fill="#f97474"/><path fill-rule="evenodd" clip-rule="evenodd" d="M6.75 13C6.75 12.3096 7.30964 11.75 8 11.75H8.00897C8.69933 11.75 9.25897 12.3096 9.25897 13C9.25897 13.6904 8.69933 14.25 8.00897 14.25H8C7.30964 14.25 6.75 13.6904 6.75 13ZM10.7455 13C10.7455 12.3096 11.3052 11.75 11.9955 11.75H12.0045C12.6948 11.75 13.2545 12.3096 13.2545 13C13.2545 13.6904 12.6948 14.25 12.0045 14.25H11.9955C11.3052 14.25 10.7455 13.6904 10.7455 13ZM14.741 13C14.741 12.3096 15.3007 11.75 15.991 11.75H16C16.6904 11.75 17.25 12.3096 17.25 13C17.25 13.6904 16.6904 14.25 16 14.25H15.991C15.3007 14.25 14.741 13.6904 14.741 13ZM6.75 17C6.75 16.3096 7.30964 15.75 8 15.75H8.00897C8.69933 15.75 9.25897 16.3096 9.25897 17C9.25897 17.6904 8.69933 18.25 8.00897 18.25H8C7.30964 18.25 6.75 17.6904 6.75 17ZM10.7455 17C10.7455 16.3096 11.3052 15.75 11.9955 15.75H12.0045C12.6948 15.75 13.2545 16.3096 13.2545 17C13.2545 17.6904 12.6948 18.25 12.0045 18.25H11.9955C11.3052 18.25 10.7455 17.6904 10.7455 17Z" fill="#f97474"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Events")}</h5>
								<p class="m-0">{__("Members can organize community events for online and offline doings")}</p>
							</a>
						</div>
					{/if}
					{if $system['blogs_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/blogs" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5.82795 6.74988L6.81765 6.74988C7.33048 6.74988 7.74622 7.18267 7.74622 7.71655V8.68322H5.88907C4.98736 8.68322 4.40448 8.68527 3.97501 8.74538C3.57226 8.80175 3.44602 8.89276 3.37533 8.96635C3.30465 9.03993 3.21722 9.17135 3.16307 9.59063C3.10533 10.0377 3.10336 10.6445 3.10336 11.5832V17.8665C3.10336 18.6674 3.90553 19.3165 4.67479 19.3165C5.44404 19.3165 6.24621 18.6674 6.24621 17.8665H7.74622C7.74622 19.7351 6.29114 21.2499 4.49622 21.2499C2.70129 21.2499 1.24622 19.7351 1.24622 17.8665L1.24622 11.5196C1.24617 10.6626 1.24613 9.92429 1.32249 9.33302C1.40433 8.69935 1.58888 8.09195 2.06214 7.59927C2.53539 7.1066 3.11886 6.91448 3.72756 6.82929C4.29553 6.74979 5.00478 6.74983 5.82795 6.74988Z" fill="#3ddae5"/><path fill-rule="evenodd" clip-rule="evenodd" d="M19.3919 2.86657C18.5249 2.75001 17.4226 2.75003 16.055 2.75005L10.8843 2.75002C10.0664 2.74975 9.50821 2.74957 9.02955 2.87783C7.73546 3.22458 6.72465 4.23538 6.3779 5.52948C6.24964 6.00814 6.24983 6.56629 6.2501 7.38425V7.38425L6.25012 18C6.25012 18.9665 5.46662 19.75 4.50012 19.75C4.08591 19.75 3.75012 20.0858 3.75012 20.5C3.75012 20.9143 4.08591 21.25 4.50012 21.25H16.055C17.4226 21.2501 18.5249 21.2501 19.3919 21.1335C20.292 21.0125 21.0499 20.7536 21.6518 20.1517C22.2537 19.5498 22.5126 18.7919 22.6336 17.8918C22.7502 17.0248 22.7501 15.9225 22.7501 14.5549V9.44518C22.7501 8.07759 22.7502 6.97527 22.6336 6.1083C22.5126 5.20819 22.2537 4.45032 21.6518 3.8484C21.0499 3.24648 20.292 2.98759 19.3919 2.86657ZM10.5001 7.25C10.0859 7.25 9.75012 7.58579 9.75012 8C9.75012 8.41421 10.0859 8.75 10.5001 8.75H18.5001C18.9143 8.75 19.2501 8.41421 19.2501 8C19.2501 7.58579 18.9143 7.25 18.5001 7.25H10.5001ZM10.5001 11.25C10.0859 11.25 9.75012 11.5858 9.75012 12C9.75012 12.4142 10.0859 12.75 10.5001 12.75H13.0001C13.4143 12.75 13.7501 12.4142 13.7501 12C13.7501 11.5858 13.4143 11.25 13.0001 11.25H10.5001ZM16.0001 11.25C15.5859 11.25 15.2501 11.5858 15.2501 12C15.2501 12.4142 15.5859 12.75 16.0001 12.75H18.5001C18.9143 12.75 19.2501 12.4142 19.2501 12C19.2501 11.5858 18.9143 11.25 18.5001 11.25H16.0001ZM10.5001 15.25C10.0859 15.25 9.75012 15.5858 9.75012 16C9.75012 16.4142 10.0859 16.75 10.5001 16.75H13.0001C13.4143 16.75 13.7501 16.4142 13.7501 16C13.7501 15.5858 13.4143 15.25 13.0001 15.25H10.5001ZM16.0001 15.25C15.5859 15.25 15.2501 15.5858 15.2501 16C15.2501 16.4142 15.5859 16.75 16.0001 16.75H18.5001C18.9143 16.75 19.2501 16.4142 19.2501 16C19.2501 15.5858 18.9143 15.25 18.5001 15.25H16.0001Z" fill="#3ddae5"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Blogs")}</h5>
								<p class="m-0">{__("Sharing thoughts, ideas and creating amazing contents")}</p>
							</a>
						</div>
					{/if}
					{if $system['market_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/market" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M3 9.75C3.55229 9.75 4 10.1977 4 10.75V15.25C4 16.6925 4.00213 17.6737 4.10092 18.4086C4.19585 19.1146 4.36322 19.4416 4.58579 19.6642C4.80836 19.8868 5.13538 20.0542 5.84143 20.1491C6.57625 20.2479 7.55752 20.25 9 20.25H15C16.4425 20.25 17.4238 20.2479 18.1586 20.1491C18.8646 20.0542 19.1916 19.8868 19.4142 19.6642C19.6368 19.4416 19.8042 19.1146 19.8991 18.4086C19.9979 17.6737 20 16.6925 20 15.25V10.75C20 10.1977 20.4477 9.75 21 9.75C21.5523 9.75 22 10.1977 22 10.75V15.3205C22 16.6747 22.0001 17.7913 21.8813 18.6751C21.7565 19.6029 21.4845 20.4223 20.8284 21.0784C20.1723 21.7345 19.3529 22.0065 18.4251 22.1312C17.5413 22.2501 16.4247 22.25 15.0706 22.25H8.92943C7.57531 22.25 6.4587 22.2501 5.57494 22.1312C4.64711 22.0065 3.82768 21.7345 3.17158 21.0784C2.51547 20.4223 2.2435 19.6029 2.11875 18.6751C1.99994 17.7913 1.99997 16.6747 2 15.3206L2 10.75C2 10.1977 2.44772 9.75 3 9.75Z" fill="#ff8c53"/><path d="M3.19143 4.45934C3.19143 2.95786 4.41603 1.75 5.91512 1.75H18.0849C19.584 1.75 20.8086 2.95786 20.8086 4.45934C20.8086 5.00972 20.9532 5.55089 21.2287 6.02939L22.2149 7.74274C22.4737 8.19195 22.6839 8.55669 22.7347 9.16669C22.7553 9.41456 22.7576 9.62312 22.726 9.82441C22.6958 10.0172 22.6381 10.1717 22.5956 10.2854L22.5894 10.3023C22.0565 11.7329 20.6723 12.75 19.0513 12.75C17.695 12.75 16.5023 12.037 15.8374 10.9644C14.9338 12.0575 13.5446 12.75 12 12.75C10.4554 12.75 9.06617 12.0575 8.16259 10.9644C7.49773 12.037 6.30506 12.75 4.94875 12.75C3.32768 12.75 1.94355 11.7329 1.41065 10.3022L1.40436 10.2854C1.3619 10.1717 1.30421 10.0172 1.27397 9.82441C1.2424 9.62312 1.24469 9.41457 1.26533 9.16669C1.31613 8.55668 1.52628 8.19195 1.78509 7.74274L2.77133 6.02939C3.04677 5.55089 3.19143 5.00972 3.19143 4.45934Z" fill="#ff8c53"/><path fill-rule="evenodd" clip-rule="evenodd" d="M6 17.5C6 16.9477 6.44772 16.5 7 16.5H11C11.5523 16.5 12 16.9477 12 17.5C12 18.0523 11.5523 18.5 11 18.5H7C6.44772 18.5 6 18.0523 6 17.5Z" fill="#ff8c53"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Marketplace")}</h5>
								<p class="m-0">{__("Trusted community marketplace wherein members can post and browse items")}</p>
							</a>
						</div>
					{/if}
					{if $system['funding_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/funding" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.6172 1.96367C13.6005 1.25022 15.2246 0.833417 17.001 1.88616C18.2699 2.63818 18.9411 4.17763 18.704 5.88548C18.4648 7.60882 17.3173 9.51201 14.9639 11.195C14.1924 11.7477 13.4912 12.25 12.5016 12.25C11.512 12.25 10.8107 11.7477 10.0392 11.195C7.68578 9.51201 6.53831 7.60882 6.29908 5.88548C6.062 4.17763 6.7332 2.63818 8.00213 1.88616C9.77849 0.833417 11.4026 1.25022 12.3859 1.96367L12.5016 2.04742L12.6172 1.96367Z" fill="#b88bfd"/><path d="M5.95526 13.25C5.52244 13.25 5.12561 13.2499 4.8028 13.2933C4.44732 13.3411 4.07159 13.4535 3.76257 13.7626C3.45355 14.0716 3.3411 14.4473 3.29331 14.8028C3.24991 15.1256 3.24995 15.5224 3.25 15.9553L3.25 18.5635C3.24996 18.8917 3.24993 19.1992 3.27988 19.4561C3.31321 19.7421 3.39038 20.0427 3.59756 20.3203C3.80474 20.5979 4.07102 20.7574 4.33569 20.8707C4.57351 20.9725 4.8683 21.06 5.18291 21.1533L10.1818 22.6366C10.9063 22.8516 11.6827 22.7581 12.3377 22.3802L19.8533 18.0438C20.7865 17.5054 21.0266 16.2638 20.4051 15.4032C19.7123 14.4437 18.5017 14.0209 17.3712 14.3724L17.3697 14.3729L15.2442 15.0259C14.9956 15.1023 14.8712 15.1405 14.8322 15.2122C14.7933 15.2839 14.8398 15.4474 14.9328 15.7743C15.0037 16.0236 15.0121 16.2627 15 16.3973C15 17.3786 14.331 18.171 13.4667 18.4099L10.9258 19.1124C10.0041 19.3673 9.01687 19.2796 8.15388 18.8621L6.5336 18.0781C6.22288 17.9278 6.09286 17.554 6.2432 17.2433C6.39354 16.9326 6.7673 16.8026 7.07802 16.9529L8.69831 17.7369C9.28692 18.0217 9.96218 18.082 10.5927 17.9076L13.1336 17.2051C13.4837 17.1083 13.75 16.7884 13.75 16.3973C13.75 14.9842 12.5733 14.6252 11.1741 14.6252L10.1315 14.6251C9.94974 14.6251 9.77138 14.5841 9.61081 14.5064L7.56883 13.5184C7.20322 13.3415 6.80136 13.25 6.39483 13.25L5.95526 13.25Z" fill="#b88bfd"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Funding")}</h5>
								<p class="m-0">{__("Fundraisers make it easy to support friends, family and the causes that are important to you")}</p>
							</a>
						</div>
					{/if}
					{if $system['offers_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/offers" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M11.1015 2.20193C11.2777 2.43653 11.6079 2.59439 12 2.59439C12.3921 2.59439 12.7223 2.43653 12.8985 2.20193C13.8517 0.932852 15.815 0.932852 16.7682 2.20193L17.2866 2.89215C17.3484 2.97448 17.4531 3.02499 17.5793 3.01861C17.7053 3.01225 17.7998 2.95211 17.8492 2.86875C18.3169 2.07995 19.1835 1.866 19.8799 2.03843C20.5785 2.2114 21.25 2.8137 21.25 3.74787V20.2524C21.25 21.1865 20.5785 21.7888 19.8799 21.9618C19.1835 22.1342 18.3169 21.9203 17.8492 21.1315C17.7998 21.0481 17.7053 20.988 17.5793 20.9816C17.4531 20.9753 17.3484 21.0258 17.2866 21.1081L16.7682 21.7983C15.815 23.0674 13.8517 23.0674 12.8985 21.7983C12.7223 21.5637 12.3921 21.4059 12 21.4059C11.6079 21.4059 11.2777 21.5637 11.1015 21.7983C10.1483 23.0674 8.18499 23.0674 7.23183 21.7983L6.71343 21.1081C6.65159 21.0258 6.54686 20.9753 6.42071 20.9816C6.29466 20.988 6.20024 21.0481 6.15081 21.1315C5.68309 21.9203 4.81652 22.1342 4.1201 21.9618C3.42148 21.7888 2.75 21.1865 2.75 20.2524V3.74787C2.75 2.8137 3.42148 2.2114 4.1201 2.03843C4.81652 1.866 5.68309 2.07995 6.15081 2.86875C6.20024 2.95211 6.29466 3.01225 6.42071 3.01861C6.54686 3.02499 6.65159 2.97448 6.71343 2.89215L7.23183 2.20193C8.18499 0.932852 10.1483 0.932852 11.1015 2.20193ZM8.29289 15.7072C7.90237 15.3167 7.90237 14.6835 8.29289 14.293L14.2929 8.29302C14.6834 7.90249 15.3166 7.90249 15.7071 8.29302C16.0976 8.68354 16.0976 9.3167 15.7071 9.70723L9.70711 15.7072C9.31658 16.0978 8.68342 16.0978 8.29289 15.7072ZM9.00897 8.00012H9C8.44772 8.00012 8 8.44784 8 9.00012C8 9.55241 8.44772 10.0001 9 10.0001H9.00897C9.56125 10.0001 10.009 9.55241 10.009 9.00012C10.009 8.44784 9.56125 8.00012 9.00897 8.00012ZM14.991 14.0001C14.4387 14.0001 13.991 14.4478 13.991 15.0001C13.991 15.5524 14.4387 16.0001 14.991 16.0001H15C15.5523 16.0001 16 15.5524 16 15.0001C16 14.4478 15.5523 14.0001 15 14.0001H14.991Z" fill="#58ca71"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Offers")}</h5>
								<p class="m-0">{__("Find the best offers that you can buy")}</p>
							</a>
						</div>
					{/if}
					{if $system['jobs_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/jobs" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2.39934 14.1478C2.38872 13.9237 2.38341 13.8117 2.44474 13.7835C2.50606 13.7553 2.58907 13.8337 2.75511 13.9904C5.28365 16.377 8.90531 17.2495 12.0008 17.2495C15.0964 17.2495 18.7184 16.3769 21.2469 13.9899C21.413 13.8332 21.496 13.7548 21.5573 13.783C21.6186 13.8112 21.6133 13.9232 21.6027 14.1473L21.5946 14.3191C21.5148 15.9916 21.4511 17.325 21.2556 18.3684C21.0531 19.4486 20.6925 20.3204 19.947 20.9989C19.2062 21.673 18.2896 21.9703 17.1645 22.1117C16.0684 22.2495 14.6731 22.2495 12.909 22.2495H11.093C9.32888 22.2495 7.93358 22.2495 6.83749 22.1117C5.71239 21.9703 4.79581 21.673 4.05506 20.9989C3.30948 20.3204 2.94895 19.4486 2.74647 18.3684C2.55089 17.325 2.48726 15.9916 2.40746 14.3191L2.39934 14.1478Z" fill="#f983be"/><path fill-rule="evenodd" clip-rule="evenodd" d="M1.98188 7.40879C2.33898 6.32293 3.19908 5.25 4.6481 5.25H19.3521C20.8011 5.25 21.6612 6.32292 22.0183 7.40879C22.3726 8.486 22.3322 9.81185 21.8167 10.7921C19.93 14.3799 15.7485 15.75 12.0001 15.75C8.2517 15.75 4.07016 14.3799 2.18347 10.7921C1.66797 9.81185 1.62763 8.486 1.98188 7.40879ZM11.9957 10C11.4459 10 11.0002 10.4477 11.0002 11C11.0002 11.5523 11.4459 12 11.9957 12H12.0047C12.5545 12 13.0002 11.5523 13.0002 11C13.0002 10.4477 12.5545 10 12.0047 10H11.9957Z" fill="#f983be"/><path fill-rule="evenodd" clip-rule="evenodd" d="M11.8251 1.5C11.9423 1.50001 12.06 1.50001 12.1764 1.5C12.8218 1.49995 13.4007 1.49989 13.8806 1.56382C14.4114 1.63451 14.9182 1.79327 15.3723 2.17507C15.8132 2.54582 16.0763 3.02008 16.2809 3.53295C16.4752 4.02046 16.652 4.63914 16.8603 5.36828L16.9623 5.72529L15.0392 6.27473L14.9509 5.96567C14.7252 5.17561 14.5754 4.6557 14.4231 4.27373C14.2767 3.90647 14.168 3.7755 14.0851 3.70581C14.0153 3.64718 13.9125 3.58572 13.6165 3.54631C13.2843 3.50205 12.8402 3.50001 12.1177 3.50001H11.8838C11.1613 3.50001 10.7172 3.50205 10.385 3.54631C10.0891 3.58572 9.98619 3.64718 9.91646 3.70581C9.83358 3.7755 9.72488 3.90647 9.57844 4.27373C9.42613 4.6557 9.27633 5.17561 9.0506 5.96567L8.96229 6.27473L7.03925 5.72529C7.07324 5.60629 7.10725 5.48729 7.14124 5.3683C7.34954 4.63915 7.52629 4.02046 7.72068 3.53295C7.92519 3.02008 8.18838 2.54582 8.62928 2.17507C9.08332 1.79327 9.59018 1.63451 10.1209 1.56382C10.6008 1.49989 11.1798 1.49995 11.8251 1.5Z" fill="#f983be"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Jobs")}</h5>
								<p class="m-0">{__("Seeking for a job, You can find theme here")}</p>
							</a>
						</div>
					{/if}
					{if $system['courses_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/courses" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.74219 1C4.53305 1 2.74219 2.79086 2.74219 5C2.74219 5.07917 2.74449 5.15779 2.74902 5.23582V14.0564C2.74901 15.8942 2.749 17.3498 2.90216 18.489C3.05979 19.6614 3.3919 20.6104 4.14027 21.3588C4.88863 22.1071 5.83758 22.4392 7.01 22.5969C8.14921 22.75 9.60487 22.75 11.4426 22.75H12.5555C14.3932 22.75 15.8488 22.75 16.988 22.5969C18.1605 22.4392 19.1094 22.1071 19.8578 21.3588C20.6061 20.6104 20.9383 19.6614 21.0959 18.489C21.2491 17.3498 21.249 15.8942 21.249 14.0564V10C21.249 8.48122 20.0178 7.25 18.499 7.25L18.499 6.5C18.499 5.11929 17.3797 4 15.999 4H7.49902C6.94674 4 6.49902 4.44772 6.49902 5C6.49902 5.55228 6.94674 6 7.49902 6H15.999C16.2752 6 16.499 6.22386 16.499 6.5V7H6.74219C5.63762 7 4.74219 6.10457 4.74219 5C4.74219 3.89543 5.63762 3 6.74219 3H18.7422C19.2945 3 19.7422 2.55228 19.7422 2C19.7422 1.44772 19.2945 1 18.7422 1H6.74219ZM12.0002 11.25C11.4526 11.25 10.9404 11.569 10.7184 12.0869L8.31083 17.7046C8.14767 18.0853 8.32403 18.5262 8.70475 18.6894C9.08547 18.8525 9.52638 18.6762 9.68955 18.2954L10.3519 16.75H13.6485L14.3108 18.2954C14.474 18.6762 14.9149 18.8525 15.2956 18.6894C15.6764 18.5262 15.8527 18.0853 15.6896 17.7046L13.282 12.0869C13.06 11.569 12.5478 11.25 12.0002 11.25ZM12.0002 12.9039L13.0056 15.25H10.9947L12.0002 12.9039Z" fill="#b88bfd"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Courses")}</h5>
								<p class="m-0">{__("Learn new skills, pursue your interests or advance your career with our short online courses")}</p>
							</a>
						</div>
					{/if}
					{if $system['forums_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/forums" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.25 16.2617C10.25 12.9108 13.0802 10.25 16.5 10.25C19.9198 10.25 22.75 12.9108 22.75 16.2617C22.75 17.8671 22.0953 19.3213 21.039 20.3939C20.9957 20.4379 20.9721 20.478 20.9621 20.5032C20.9595 20.5098 20.9581 20.5143 20.9575 20.5171C21.0261 20.8706 21.1789 21.1975 21.3988 21.468C21.5658 21.6733 21.6121 21.9514 21.5209 22.1998C21.4296 22.4482 21.2142 22.6301 20.954 22.6785C19.9913 22.8576 18.9951 22.6961 18.1416 22.2422C18.0361 22.1861 17.9664 22.1492 17.9148 22.1234C17.8665 22.1314 17.8009 22.1436 17.7025 22.1621C17.306 22.2365 16.9034 22.2739 16.4995 22.2734C13.08 22.2731 10.25 19.6125 10.25 16.2617Z" fill="#dcce4f"/><path d="M11 1.25C5.64745 1.25 1.25 5.41003 1.25 10.61C1.25 13.1039 2.26637 15.3654 3.9126 17.037C4.14324 17.2712 4.2056 17.4985 4.1771 17.6507C4.05135 18.3102 3.76709 18.9225 3.35406 19.4306C3.18713 19.6359 3.14075 19.914 3.23202 20.1624C3.32329 20.4107 3.53869 20.5926 3.79885 20.641C5.26585 20.9139 6.7864 20.668 8.08964 19.9749C8.2562 19.8864 8.37575 19.8229 8.4685 19.7765C8.52845 19.7465 8.55843 19.7315 8.58217 19.7241C8.60285 19.7178 8.60711 19.7167 8.60787 19.7166C8.61159 19.7158 8.60229 19.7178 8.60802 19.7168C8.61376 19.7158 8.60444 19.717 8.60816 19.7165C8.62713 19.714 8.64925 19.7137 8.67407 19.7175C8.77272 19.731 8.9062 19.7559 9.12044 19.7961C9.36087 19.8413 9.53788 19.5825 9.43432 19.3609C8.99592 18.4227 8.75 17.3758 8.75 16.2617C8.75 12.0181 12.3175 8.75 16.5 8.75C17.6243 8.75 18.7042 8.98615 19.6822 9.41393C20.1809 9.632 20.4302 9.74104 20.5719 9.62639C20.7137 9.51173 20.6649 9.27283 20.5673 8.79503C19.6849 4.47485 15.7127 1.25 11 1.25Z" fill="#dcce4f"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Forums")}</h5>
								<p class="m-0">{__("Forum is an old­school framework for online community")}</p>
							</a>
						</div>
					{/if}
					{if $system['movies_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/movies" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M1.75 11.9428V12.0572C1.74999 14.2479 1.74998 15.9686 1.93059 17.312C2.11568 18.6886 2.50272 19.7809 3.36091 20.6391C4.21911 21.4973 5.31137 21.8843 6.68802 22.0694C8.03144 22.25 9.75212 22.25 11.9428 22.25H12.0572C14.2479 22.25 15.9686 22.25 17.312 22.0694C18.6886 21.8843 19.7809 21.4973 20.6391 20.6391C21.4973 19.7809 21.8843 18.6886 22.0694 17.312C22.25 15.9686 22.25 14.2479 22.25 12.0572V11.9428C22.25 9.75214 22.25 8.03143 22.0694 6.68802C21.8843 5.31137 21.4973 4.21911 20.6391 3.36091C19.7809 2.50271 18.6886 2.11568 17.312 1.93059C15.9686 1.74998 14.2479 1.74999 12.0572 1.75H12.0572H11.9428H11.9428C9.75213 1.74999 8.03144 1.74998 6.68802 1.93059C5.31137 2.11568 4.21911 2.50271 3.36091 3.36091C2.50271 4.21911 2.11568 5.31137 1.93059 6.68802C1.74998 8.03144 1.74999 9.75212 1.75 11.9428ZM11.0001 14.9998C11.0001 15.4713 11.0001 15.707 10.8537 15.8534C10.7072 15.9998 10.4715 15.9998 10.0001 15.9998L4.2564 15.9998H4.25639C3.80822 15.9998 3.58414 15.9998 3.43859 15.8583C3.29303 15.7167 3.28693 15.4974 3.27472 15.0588C3.25056 14.1905 3.25012 13.1829 3.25012 11.9998C3.25012 10.8168 3.25056 9.80923 3.27472 8.94091C3.28693 8.50228 3.29303 8.28297 3.43859 8.14141C3.58414 7.99985 3.80823 7.99985 4.2564 7.99985H10.0001C10.4715 7.99985 10.7072 7.99985 10.8537 8.14629C11.0001 8.29274 11.0001 8.52844 11.0001 8.99985L11.0001 14.9998ZM13.0001 8.99985V8.99984C13.0001 8.52844 13.0001 8.29274 13.1466 8.14629C13.293 7.99985 13.5287 7.99985 14.0001 7.99985H19.7438C20.192 7.99985 20.4161 7.99985 20.5617 8.14141C20.7072 8.28297 20.7133 8.50228 20.7255 8.94091C20.7497 9.80923 20.7501 10.8168 20.7501 11.9998C20.7501 13.1829 20.7497 14.1905 20.7255 15.0588C20.7133 15.4974 20.7072 15.7167 20.5617 15.8583C20.4161 15.9998 20.192 15.9998 19.7438 15.9998L14.0001 15.9998C13.5287 15.9998 13.293 15.9998 13.1466 15.8534C13.0001 15.707 13.0001 15.4713 13.0001 14.9999V14.9998L13.0001 8.99985ZM8.93804 3.55959C8.87661 3.50057 8.78043 3.50441 8.58808 3.5121C8.14563 3.52978 7.7312 3.55547 7.35306 3.59281C7.18899 3.609 7.10695 3.6171 7.05517 3.67417C7.00339 3.73123 7.00327 3.81544 7.00303 3.98386V3.98387L7.00003 6.09771C6.99977 6.28651 6.99963 6.38092 7.05823 6.4396C7.11682 6.49828 7.21123 6.49828 7.40003 6.49828H8.59947C8.78803 6.49828 8.88231 6.49828 8.94089 6.4397C8.99947 6.38112 8.99947 6.28684 8.99947 6.09828L8.99947 3.90971C8.99947 3.71565 8.99947 3.61862 8.93804 3.55959ZM15.0609 3.5596C15.1223 3.50057 15.2185 3.50441 15.4108 3.5121C15.8533 3.52978 16.2677 3.55547 16.6459 3.59281C16.8099 3.609 16.892 3.6171 16.9438 3.67417C16.9955 3.73123 16.9957 3.81544 16.9959 3.98387L16.9989 6.09771C16.9992 6.28651 16.9993 6.38092 16.9407 6.4396C16.8821 6.49828 16.7877 6.49828 16.5989 6.49828H15.3995C15.2109 6.49828 15.1166 6.49828 15.058 6.4397C14.9995 6.38112 14.9995 6.28684 14.9995 6.09828V3.90971C14.9995 3.71565 14.9995 3.61862 15.0609 3.5596ZM8.58808 20.4843C8.78043 20.4919 8.8766 20.4958 8.93804 20.4368C8.99947 20.3777 8.99947 20.2807 8.99947 20.0867V17.8981C8.99947 17.7095 8.99947 17.6152 8.94089 17.5567C8.88231 17.4981 8.78803 17.4981 8.59947 17.4981H7.40003C7.21123 17.4981 7.11682 17.4981 7.05823 17.5568C6.99963 17.6154 6.99977 17.7098 7.00003 17.8987L7.00303 20.0125C7.00327 20.1809 7.00339 20.2651 7.05517 20.3222C7.10695 20.3793 7.18899 20.3874 7.35306 20.4036C7.7312 20.4409 8.14563 20.4666 8.58808 20.4843ZM15.0609 20.4368C15.1223 20.4958 15.2185 20.4919 15.4108 20.4843C15.8533 20.4666 16.2677 20.4409 16.6459 20.4036C16.8099 20.3874 16.892 20.3793 16.9438 20.3222C16.9955 20.2651 16.9957 20.1809 16.9959 20.0125L16.9989 17.8987C16.9992 17.7098 16.9993 17.6154 16.9407 17.5568C16.8821 17.4981 16.7877 17.4981 16.5989 17.4981H15.3995C15.2109 17.4981 15.1166 17.4981 15.058 17.5567C14.9995 17.6152 14.9995 17.7095 14.9995 17.8981V20.0867C14.9995 20.2807 14.9995 20.3777 15.0609 20.4368Z" fill="#3ddae5"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Movies")}</h5>
								<p class="m-0">{__("Watching movies always fun, Watch with the people who share your interests")}</p>
							</a>
						</div>
					{/if}
					{if $system['games_enabled']}
						<div class="col-sm-6 col-md-6 mb-3">
							<a href="{$system['system_url']}/directory/games" class="directory-card x_address d-block h-100 p-3 body-color">
								<svg width="36" height="36" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.9319 3.87827C8.06823 4.41346 7.74489 4.95784 7.2097 5.09417L5.24685 5.59417C4.71166 5.7305 4.16728 5.40716 4.03095 4.87197C3.89462 4.33677 4.21796 3.79239 4.75315 3.65606L6.716 3.15606C7.25119 3.01973 7.79557 3.34308 7.9319 3.87827ZM16.0299 3.88258C16.1638 3.34679 16.7067 3.02103 17.2425 3.15498L19.2425 3.65498C19.7783 3.78892 20.1041 4.33186 19.9701 4.86765C19.8362 5.40345 19.2933 5.72921 18.7575 5.59526L16.7575 5.09526C16.2217 4.96131 15.8959 4.41838 16.0299 3.88258Z" fill="#f97474"/><path fill-rule="evenodd" clip-rule="evenodd" d="M4.92509 6.17612C9.34102 5.1078 14.659 5.1078 19.0749 6.17612C20.1031 6.42487 20.8958 7.16741 21.2589 8.13694C21.8432 9.697 22.5131 12.3264 22.7403 15.8863C22.9054 18.4745 20.9807 19.8307 19.2803 20.6872C18.8223 20.9179 18.3491 20.9286 17.9171 20.7592C17.5185 20.603 17.2028 20.3134 16.96 20.025C16.4777 19.4522 16.1003 18.6588 15.8299 18.0493C15.6563 17.6579 15.2779 17.4105 14.8281 17.4105H9.17196C8.72218 17.4105 8.34378 17.6579 8.17012 18.0493C7.89974 18.6588 7.52233 19.4522 7.04 20.025C6.79722 20.3134 6.48151 20.603 6.08295 20.7592C5.6509 20.9286 5.17774 20.9179 4.7197 20.6872C3.03995 19.8411 1.09341 18.4935 1.25978 15.8863C1.48693 12.3264 2.15683 9.697 2.74109 8.13694C3.10419 7.16741 3.89689 6.42487 4.92509 6.17612ZM9.70691 9.41777C10.0974 9.8083 10.0974 10.4415 9.70691 10.832L8.91401 11.6249L9.70691 12.4178C10.0974 12.8083 10.0974 13.4415 9.70691 13.832C9.31638 14.2225 8.68322 14.2225 8.2927 13.832L7.4998 13.0391L6.70691 13.832C6.31638 14.2225 5.68322 14.2225 5.2927 13.832C4.90217 13.4415 4.90217 12.8083 5.2927 12.4178L6.08559 11.6249L5.2927 10.832C4.90217 10.4415 4.90217 9.8083 5.2927 9.41777C5.68322 9.02725 6.31638 9.02725 6.70691 9.41777L7.4998 10.2107L8.29269 9.41777C8.68322 9.02725 9.31638 9.02725 9.70691 9.41777ZM15.9971 11.1249H15.9881C15.4358 11.1249 14.9881 10.6772 14.9881 10.1249C14.9881 9.57259 15.4358 9.12488 15.9881 9.12488H15.9971C16.5493 9.12488 16.9971 9.57259 16.9971 10.1249C16.9971 10.6772 16.5493 11.1249 15.9971 11.1249ZM16.9881 13.1249C16.9881 12.5726 17.4358 12.1249 17.9881 12.1249H17.9971C18.5493 12.1249 18.9971 12.5726 18.9971 13.1249C18.9971 13.6772 18.5493 14.1249 17.9971 14.1249H17.9881C17.4358 14.1249 16.9881 13.6772 16.9881 13.1249Z" fill="#f97474"/></svg>
								<h5 class="mt-3 fw-semibold h4">{__("Games")}</h5>
								<p class="m-0">{__("Playing games always fun, Play with the people who share your interests")}</p>
							</a>
						</div>
					{/if}
				</div>
			</div>
		</div>
		<!-- content panel -->
    </div>

{else}

    <div class="row x_content_row">
		<!-- left panel -->
		<div class="col-lg-8">
			<div class="position-sticky x_top_posts">
				<div class="headline-font fw-semibold side_widget_title p-3">
					{__("Directory")}
				</div>
				
				<div class="d-flex align-items-center justify-content-center">
					<div {if $view == "users"}class="active fw-semibold"{/if}>
						<a href="{$system['system_url']}/directory/users" class="body-color side_item_hover w-100 text-center d-block">
							<span class="position-relative d-inline-block py-3">{__("Users")}</span>
						</a>
					</div>
					<div {if $view == "posts"}class="active fw-semibold"{/if}>
						<a href="{$system['system_url']}/directory/posts" class="body-color side_item_hover w-100 text-center d-block">
							<span class="position-relative d-inline-block py-3">{__("Posts")}</span>
						</a>
					</div>
					{if $system['pages_enabled']}
						<div {if $view == "pages"}class="active fw-semibold" {/if}>
							<a href="{$system['system_url']}/directory/pages" class="body-color side_item_hover w-100 text-center d-block">
								<span class="position-relative d-inline-block py-3">{__("Pages")}</span>
							</a>
						</div>
					{/if}
					{if $system['groups_enabled']}
						<div {if $view == "groups"}class="active fw-semibold" {/if}>
							<a href="{$system['system_url']}/directory/groups" class="body-color side_item_hover w-100 text-center d-block">
								<span class="position-relative d-inline-block py-3">{__("Groups")}</span>
							</a>
						</div>
					{/if}
					{if $system['events_enabled']}
						<div {if $view == "events"}class="active fw-semibold" {/if}>
							<a href="{$system['system_url']}/directory/events" class="body-color side_item_hover w-100 text-center d-block">
								<span class="position-relative d-inline-block py-3">{__("Events")}</span>
							</a>
						</div>
					{/if}
					{if $system['games_enabled']}
						<div {if $view == "games"}class="active fw-semibold" {/if}>
							<a href="{$system['system_url']}/directory/games" class="body-color side_item_hover w-100 text-center d-block">
								<span class="position-relative d-inline-block py-3">{__("Games")}</span>
							</a>
						</div>
					{/if}
				</div>
			</div>
			
			{if $view == "users"}
				{if $rows}
					<ul>
						{foreach $rows as $_user}
							{include file='__feeds_user.tpl' _tpl="list" _connection=$_user["connection"]}
						{/foreach}
					</ul>
					{$pager}
				{else}
					{include file='_no_data.tpl'}
				{/if}

            {elseif $view == "posts"}
				{if $rows}
					<ul>
						{foreach $rows as $post}
							{include file='__feeds_post.tpl'}
						{/foreach}
					</ul>
					{$pager}
				{else}
					{include file='_no_data.tpl'}
				{/if}

            {elseif $view == "pages"}
				{if $rows}
					<ul>
						{foreach $rows as $_page}
							{include file='__feeds_page.tpl' _tpl="list"}
						{/foreach}
					</ul>
					{$pager}
				{else}
					{include file='_no_data.tpl'}
				{/if}

            {elseif $view == "groups"}
				{if $rows}
					<ul>
						{foreach $rows as $_group}
							{include file='__feeds_group.tpl' _tpl="list"}
						{/foreach}
					</ul>
					{$pager}
				{else}
					{include file='_no_data.tpl'}
				{/if}

            {elseif $view == "events"}
				{if $rows}
					<ul>
						{foreach $rows as $_event}
							{include file='__feeds_event.tpl' _tpl="list"}
						{/foreach}
					</ul>
					{$pager}
				{else}
					{include file='_no_data.tpl'}
				{/if}

            {elseif $view == "games"}
				{if $rows}
					<ul>
						{foreach $rows as $_game}
							{include file='__feeds_game.tpl' _tpl="list"}
						{/foreach}
					</ul>
					{$pager}
				{else}
					{include file='_no_data.tpl'}
				{/if}

            {/if}
		</div>
		<!-- left panel -->
		
		<!-- right panel -->
		<div class="col-lg-4 js_sticky-sidebar">
			<!-- upgrade to pro -->	
			{if $system['packages_enabled'] && !$user->_data['user_subscribed']}
				<div class="mb-3 overflow-hidden content">
					<h6 class="headline-font fw-semibold m-0 side_widget_title">
						{__("Upgrade to Pro")}
					</h6>
					<div class="px-3 py-0 side_item_list">
						{__("Choose the Plan That's Right for You")}
					</div>
					<div class="px-3 side_item_list">
						<a class="btn btn-main" href="{$system['system_url']}/packages">
							{__("Upgrade")}
						</a>
					</div>
				</div>
			{/if}
			<!-- upgrade to pro -->
			
			<!-- trending -->
			{if $trending_hashtags}
				{include file='_trending_widget.tpl'}
			{/if}
			<!-- trending -->

			{include file='_ads.tpl'}
			{include file='_ads_campaigns.tpl'}
			{include file='_widget.tpl'}
			
			<!-- mini footer -->
			{include file='_footer_mini.tpl'}
			<!-- mini footer -->
		</div>
		<!-- right panel -->
    </div>
{/if}
<!-- page content -->

{include file='_footer.tpl'}